/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm2210;

import ibm.nways.jdm.BrowserApplet;
import ibm.nways.jdm.GraphicAction;
import ibm.nways.jdm.GraphicActionNavigate;
import ibm.nways.jdm.GraphicComponent;
import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicHandler;
import ibm.nways.jdm.GraphicHelp;
import ibm.nways.jdm.GraphicImage;
import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.HelpRef;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.JdmLayout;
import ibm.nways.jdm.NavigationDestination;
import ibm.nways.jdm.RemoteModel;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.ras.RAS;
import ibm.nways.widgets.CookieTray;
import ibm.nways.widgets.WidgetCookie;
import java.awt.Component;
import java.awt.Point;
import java.io.Serializable;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class Box24XGraphic {
    private GenModel jdm2210Model;
    private GenModel systemModel;
    private GenModel interface2210Model;
    private GenModel jdm2210ResetModel;
    private JdmBrowser jdm2210Browser;
    private Vector interfaceInfo;
    private String resourceFile = "ibm.nways.jdm2210.Resources";
    private String WCPath = "ibm.nways.jdm2210.WCDefault";
    private int boxType;
    private int featureSlot;
    private Point boxPoint = new Point(20, 20);
    private Point featurePoint = new Point(242, 33);
    private static final String PropertiesFile = "properties/jdm2210.txt";
    private static final String layoutKey = "box.layout.scheme";
    private static final String fractKey = "box.layout.fractions";
    private static final int RASID = 19;
    private static final int RASSUB = 14;
    static final String HelpRef_Dir = "ibm.nways.jdm2210";
    static final String HelpRef_2210html = "ibm.nways.jdm2210.BoxGraphic.html";

    protected Box24XGraphic(JdmBrowser jdmBrowser, int n, int n2) {
        this.jdm2210Browser = jdmBrowser;
        this.boxType = n;
        this.featureSlot = n2;
    }

    protected GraphicPanel getGraphicPanel() {
        String string;
        Hashtable hashtable;
        Serializable serializable;
        String string2 = "getGraphicPanel";
        GraphicContainer graphicContainer = new GraphicContainer();
        try {
            serializable = new URL(this.jdm2210Browser.getDocumentBase(), PropertiesFile);
            System.out.println("DocumentBase = " + this.jdm2210Browser.getDocumentBase());
            RAS.trace(19, 14, this, string2, "DocumentBase: " + this.jdm2210Browser.getDocumentBase());
            hashtable = new Properties();
            ((Properties)hashtable).load(((URL)serializable).openStream());
        }
        catch (Exception exception) {
            RAS.logError(19, 14, this, string2, "EXCEPTION_GETTING_PROPERTIES");
            RAS.logException(19, 14, this, string2, exception);
            hashtable = null;
        }
        JdmLayout jdmLayout = (JdmLayout)this.jdm2210Browser.getLayout();
        if (hashtable != null) {
            serializable = new Integer((String)hashtable.get(layoutKey));
            if (RAS.isEnabled(19, 14)) {
                RAS.trace(19, 14, this, string2, "The layout scheme property = " + serializable);
            }
            int n = (Integer)serializable;
            jdmLayout.setScheme(n);
            string = (String)hashtable.get(fractKey);
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            float[] fArray = new float[stringTokenizer.countTokens()];
            boolean bl = true;
            int n2 = 0;
            while (n2 < fArray.length && stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                try {
                    fArray[n2] = Float.valueOf(string3).floatValue();
                }
                catch (NumberFormatException numberFormatException) {
                    RAS.logError(19, 14, this, string2, "EXCEPTION_CALCULATING_FRACTIONS");
                    RAS.logException(19, 14, this, string2, (Exception)numberFormatException);
                    bl = false;
                }
                ++n2;
            }
            if (bl) {
                jdmLayout.setFracts(fArray);
            }
        }
        this.getBoxInfo();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("ibm.nways.jdm2210.Resources");
        if (this.interfaceInfo == null) {
            try {
                this.interfaceInfo = this.interface2210Model.getRestOfInfo("_Empty", "default", null, null);
            }
            catch (Exception exception) {
                RAS.logException(19, 14, this, string2, exception);
            }
        }
        GraphicImage graphicImage = new GraphicImage(this.jdm2210Browser.imageFrom((Object)this, "box24X.gif"), this.boxPoint, 3, (GraphicAction)new GraphicActionNavigate((GraphicHandler)this.jdm2210Browser, new NavigationDestination("ibm.nways.mib2.eui.SystemPanel", (RemoteModel)this.systemModel), null), null);
        graphicContainer.add((GraphicComponent)graphicImage);
        serializable = new GraphicHelp((BrowserApplet)this.jdm2210Browser, new Point(0, 0), new HelpRef(HelpRef_Dir, HelpRef_2210html));
        graphicContainer.add((GraphicComponent)serializable);
        if (this.boxType == 10) {
            graphicContainer.add((GraphicContainer)this.bakeCookie("ETHERNET1", (ModelInfo)this.interfaceInfo.elementAt(0)));
            graphicContainer.add((GraphicContainer)this.bakeCookie("ETHERNET2", (ModelInfo)this.interfaceInfo.elementAt(5)));
        } else if (this.boxType == 11) {
            graphicContainer.add((GraphicContainer)this.bakeCookie("ETHERNET", (ModelInfo)this.interfaceInfo.elementAt(0)));
            graphicContainer.add((GraphicContainer)this.bakeCookie("TOKENRINGR", (ModelInfo)this.interfaceInfo.elementAt(5)));
        } else if (this.boxType == 12) {
            graphicContainer.add((GraphicContainer)this.bakeCookie("TOKENRING1", (ModelInfo)this.interfaceInfo.elementAt(0)));
            graphicContainer.add((GraphicContainer)this.bakeCookie("TOKENRING2", (ModelInfo)this.interfaceInfo.elementAt(5)));
        } else if (this.boxType == 13) {
            graphicContainer.add((GraphicContainer)this.bakeCookie("TOKENRINGL", (ModelInfo)this.interfaceInfo.elementAt(0)));
        }
        graphicContainer.add((GraphicContainer)this.bakeCookie("WAN1", (ModelInfo)this.interfaceInfo.elementAt(1)));
        graphicContainer.add((GraphicContainer)this.bakeCookie("WAN2", (ModelInfo)this.interfaceInfo.elementAt(2)));
        graphicContainer.add((GraphicContainer)this.bakeCookie("WAN3", (ModelInfo)this.interfaceInfo.elementAt(3)));
        graphicContainer.add((GraphicContainer)this.bakeCookie("WAN4", (ModelInfo)this.interfaceInfo.elementAt(4)));
        string = new WidgetCookie("RESETBUTTON24x", this.resourceFile, null, this.WCPath, this.jdm2210ResetModel, this.jdm2210Browser, 16, "ibm.nways.jdm2210.eui.Reset2210Panel");
        graphicContainer.add((GraphicContainer)string);
        this.DetermineFeatureSlot(this.featureSlot, graphicContainer);
        GraphicPanel graphicPanel = new GraphicPanel((GraphicHandler)this.jdm2210Browser, (Component)graphicContainer);
        return graphicPanel;
    }

    private void getBoxInfo() {
        String string = "getBoxInfo";
        if (this.jdm2210ResetModel == null) {
            try {
                this.jdm2210ResetModel = (GenModel)this.jdm2210Model.getComponent("Jdm2210Reset");
                if (RAS.isEnabled(19, 14)) {
                    RAS.trace(19, 14, this, string, "Got jdm2210ResetModel");
                }
            }
            catch (Exception exception) {
                RAS.logError(19, 14, this, string, "EXCEPTION_BUILDING_GRAPHIC");
                RAS.logException(19, 14, this, string, exception);
            }
        }
        if (this.systemModel == null) {
            try {
                this.systemModel = (GenModel)this.jdm2210Model.getComponent("System");
                if (RAS.isEnabled(19, 14)) {
                    RAS.trace(19, 14, this, string, "Got system2 model");
                }
            }
            catch (Exception exception) {
                RAS.logError(19, 14, this, string, "EXCEPTION_GETTING_MODEL_COMPONENT", (Object)"System", (Object)"Jdm2210Model");
                RAS.logException(19, 14, this, string, exception);
            }
        }
        if (this.interface2210Model == null) {
            try {
                this.interface2210Model = (GenModel)this.jdm2210Model.getComponent("Interface");
                if (RAS.isEnabled(19, 14)) {
                    RAS.trace(19, 14, this, string, "Got interface model");
                    return;
                }
            }
            catch (Exception exception) {
                RAS.logError(19, 14, this, string, "EXCEPTION_GETTING_MODEL_COMPONENT", (Object)"Interface", (Object)"Jdm2210Model");
                RAS.logException(19, 14, this, string, exception);
                return;
            }
        }
    }

    protected void setJdm2210Model(GenModel genModel) {
        this.jdm2210Model = genModel;
    }

    protected void setSystemModel(GenModel genModel) {
        this.systemModel = genModel;
    }

    private void DetermineFeatureSlot(int n, GraphicContainer graphicContainer) {
        Point point = new Point(this.featurePoint.x + this.boxPoint.x, this.featurePoint.y + this.boxPoint.y);
        CookieTray cookieTray = null;
        String string = null;
        String string2 = null;
        int n2 = 6;
        if (this.boxType == 13) {
            n2 = 5;
        }
        switch (n) {
            case 1: {
                return;
            }
            case 2: {
                string = "/ibm/nways/gifs/20_scale/horizontal/isdnBriSlot.gif";
                string2 = "Isdn Bri Adapter";
                cookieTray = new CookieTray(this.resourceFile, point, string, string2, this.jdm2210Browser);
                cookieTray.AddWidget(this.bakeCookie("ISDNBRI", (ModelInfo)this.interfaceInfo.elementAt(n2)));
                graphicContainer.add((GraphicContainer)cookieTray);
                return;
            }
            case 3: {
                string = "/ibm/nways/gifs/20_scale/horizontal/isdnPri120Slot.gif";
                string2 = "ISDN_E1_120_Adapter";
                cookieTray = new CookieTray(this.resourceFile, point, string, string2, this.jdm2210Browser);
                cookieTray.AddWidget(this.bakeCookie("ISDNPRIE1120", (ModelInfo)this.interfaceInfo.elementAt(n2)));
                graphicContainer.add((GraphicContainer)cookieTray);
                return;
            }
            case 4: {
                string = "/ibm/nways/gifs/20_scale/horizontal/isdnPriSlot.gif";
                string2 = "ISDN_E1_75_Adapter";
                cookieTray = new CookieTray(this.resourceFile, point, string, string2, this.jdm2210Browser);
                cookieTray.AddWidget(this.bakeCookie("ISDNPRIE1", (ModelInfo)this.interfaceInfo.elementAt(n2)));
                graphicContainer.add((GraphicContainer)cookieTray);
                return;
            }
            case 5: {
                string = "/ibm/nways/gifs/20_scale/horizontal/isdnPriSlot.gif";
                string2 = "ISDN T1 Adapter";
                cookieTray = new CookieTray(this.resourceFile, point, string, string2, this.jdm2210Browser);
                cookieTray.AddWidget(this.bakeCookie("ISDNPRIT1", (ModelInfo)this.interfaceInfo.elementAt(n2)));
                graphicContainer.add((GraphicContainer)cookieTray);
                return;
            }
            case 6: 
            case 7: {
                string = "/ibm/nways/gifs/20_scale/horizontal/atmSlot.gif";
                string2 = "ATM Adapter";
                cookieTray = new CookieTray(this.resourceFile, point, string, string2, this.jdm2210Browser);
                cookieTray.AddWidget(this.bakeCookie("ATM", (ModelInfo)this.interfaceInfo.elementAt(n2)));
                graphicContainer.add((GraphicContainer)cookieTray);
                return;
            }
            case 8: {
                string = "/ibm/nways/gifs/20_scale/horizontal/wan4PortSlot.gif";
                string2 = "WAN Adapter";
                cookieTray = new CookieTray(this.resourceFile, point, string, string2, this.jdm2210Browser);
                cookieTray.AddWidget(this.bakeCookie("WAN41", (ModelInfo)this.interfaceInfo.elementAt(n2)));
                cookieTray.AddWidget(this.bakeCookie("WAN42", (ModelInfo)this.interfaceInfo.elementAt(n2 + 1)));
                cookieTray.AddWidget(this.bakeCookie("WAN43", (ModelInfo)this.interfaceInfo.elementAt(n2 + 2)));
                cookieTray.AddWidget(this.bakeCookie("WAN44", (ModelInfo)this.interfaceInfo.elementAt(n2 + 3)));
                graphicContainer.add((GraphicContainer)cookieTray);
                return;
            }
            case 9: {
                string = "/ibm/nways/gifs/20_scale/horizontal/wan8PortSlot.gif";
                string2 = "WAN Adapter";
                cookieTray = new CookieTray(this.resourceFile, point, string, string2, this.jdm2210Browser);
                cookieTray.AddWidget(this.bakeCookie("WAN81", (ModelInfo)this.interfaceInfo.elementAt(n2)));
                cookieTray.AddWidget(this.bakeCookie("WAN82", (ModelInfo)this.interfaceInfo.elementAt(n2 + 1)));
                cookieTray.AddWidget(this.bakeCookie("WAN83", (ModelInfo)this.interfaceInfo.elementAt(n2 + 2)));
                cookieTray.AddWidget(this.bakeCookie("WAN84", (ModelInfo)this.interfaceInfo.elementAt(n2 + 3)));
                cookieTray.AddWidget(this.bakeCookie("WAN85", (ModelInfo)this.interfaceInfo.elementAt(n2 + 4)));
                cookieTray.AddWidget(this.bakeCookie("WAN86", (ModelInfo)this.interfaceInfo.elementAt(n2 + 5)));
                cookieTray.AddWidget(this.bakeCookie("WAN87", (ModelInfo)this.interfaceInfo.elementAt(n2 + 6)));
                cookieTray.AddWidget(this.bakeCookie("WAN88", (ModelInfo)this.interfaceInfo.elementAt(n2 + 7)));
                graphicContainer.add((GraphicContainer)cookieTray);
                return;
            }
            case 10: {
                string = "/ibm/nways/gifs/20_scale/horizontal/modem4PortSlot.gif";
                string2 = "Modem4/8";
                cookieTray = new CookieTray(this.resourceFile, point, string, string2, this.jdm2210Browser);
                cookieTray.AddWidget(this.bakeCookie("MODEM1", (ModelInfo)this.interfaceInfo.elementAt(n2)));
                cookieTray.AddWidget(this.bakeCookie("MODEM2", (ModelInfo)this.interfaceInfo.elementAt(n2 + 1)));
                cookieTray.AddWidget(this.bakeCookie("MODEM3", (ModelInfo)this.interfaceInfo.elementAt(n2 + 2)));
                cookieTray.AddWidget(this.bakeCookie("MODEM4", (ModelInfo)this.interfaceInfo.elementAt(n2 + 3)));
                graphicContainer.add((GraphicContainer)cookieTray);
                return;
            }
            case 11: {
                string = "/ibm/nways/gifs/20_scale/horizontal/modem8PortSlot.gif";
                string2 = "Modem4/8";
                cookieTray = new CookieTray(this.resourceFile, point, string, string2, this.jdm2210Browser);
                cookieTray.AddWidget(this.bakeCookie("MODEM1", (ModelInfo)this.interfaceInfo.elementAt(n2)));
                cookieTray.AddWidget(this.bakeCookie("MODEM2", (ModelInfo)this.interfaceInfo.elementAt(n2 + 1)));
                cookieTray.AddWidget(this.bakeCookie("MODEM3", (ModelInfo)this.interfaceInfo.elementAt(n2 + 2)));
                cookieTray.AddWidget(this.bakeCookie("MODEM4", (ModelInfo)this.interfaceInfo.elementAt(n2 + 3)));
                cookieTray.AddWidget(this.bakeCookie("MODEM5", (ModelInfo)this.interfaceInfo.elementAt(n2 + 4)));
                cookieTray.AddWidget(this.bakeCookie("MODEM6", (ModelInfo)this.interfaceInfo.elementAt(n2 + 5)));
                cookieTray.AddWidget(this.bakeCookie("MODEM7", (ModelInfo)this.interfaceInfo.elementAt(n2 + 6)));
                cookieTray.AddWidget(this.bakeCookie("MODEM8", (ModelInfo)this.interfaceInfo.elementAt(n2 + 7)));
                graphicContainer.add((GraphicContainer)cookieTray);
                return;
            }
            case 12: {
                string = "/ibm/nways/gifs/20_scale/horizontal/isdnBri4PortSTSlot.gif";
                string2 = "ISDN_BRI_4PORT_ST_Adapter";
                cookieTray = new CookieTray(this.resourceFile, point, string, string2, this.jdm2210Browser);
                cookieTray.AddWidget(this.bakeCookie("ISDNPORT1", (ModelInfo)this.interfaceInfo.elementAt(n2)));
                cookieTray.AddWidget(this.bakeCookie("ISDNPORT2", (ModelInfo)this.interfaceInfo.elementAt(n2 + 1)));
                cookieTray.AddWidget(this.bakeCookie("ISDNPORT3", (ModelInfo)this.interfaceInfo.elementAt(n2 + 2)));
                cookieTray.AddWidget(this.bakeCookie("ISDNPORT4", (ModelInfo)this.interfaceInfo.elementAt(n2 + 3)));
                graphicContainer.add((GraphicContainer)cookieTray);
                return;
            }
            case 13: {
                string = "/ibm/nways/gifs/20_scale/horizontal/isdnBri4PortUSlot.gif";
                string2 = "ISDN_BRI_4PORT_U_Adapter";
                cookieTray = new CookieTray(this.resourceFile, point, string, string2, this.jdm2210Browser);
                cookieTray.AddWidget(this.bakeCookie("ISDNPORT1", (ModelInfo)this.interfaceInfo.elementAt(n2)));
                cookieTray.AddWidget(this.bakeCookie("ISDNPORT2", (ModelInfo)this.interfaceInfo.elementAt(n2 + 1)));
                cookieTray.AddWidget(this.bakeCookie("ISDNPORT3", (ModelInfo)this.interfaceInfo.elementAt(n2 + 2)));
                cookieTray.AddWidget(this.bakeCookie("ISDNPORT4", (ModelInfo)this.interfaceInfo.elementAt(n2 + 3)));
                graphicContainer.add((GraphicContainer)cookieTray);
                return;
            }
        }
    }

    private WidgetCookie bakeCookie(String string, ModelInfo modelInfo) {
        return new WidgetCookie(string, this.resourceFile, modelInfo, this.WCPath, this.interface2210Model, this.jdm2210Browser, 16);
    }
}

